# Details About This Wiki

Technical and structural notes about this wiki.

## Structure

```
unnamed-2026-02-20/
├── README.md (homepage)
├── Conversation Flow.md (narrative arc)
├── Concept Index.md (pages by type)
├── Alphabetical Index.md (A-Z)
├── Work Log.md (process journal)
├── Wiki Creation Process.md (methodology)
├── Details About This Wiki.md (this page)
├── Pete Kaminski.md
├── Jessie Upp.md
├── The Nameless One.md
├── [Conversation Thread pages] (~12)
├── [Synthesis pages] (3: The Aquifer, The Aquifer v2, The Nameless Can Never Be Named)
├── [Reference pages] (~20+)
├── Inter-Face Manifesto.md
├── Call Artifacts/
│   ├── jessie, pete, nameless one, 2026-02-20 - meeting_saved_closed_caption.txt
│   └── meeting_saved_new_chat.txt
├── Instructions for AI Assistant - Two-Person Call.md
└── _bin/
    ├── find-orphan-links.py
    └── fix-linebreaks.py
```

## Conventions

### Links
- `[[Double Square Bracket Links]]` throughout
- `[[Page|display text]]` where display text differs from page name
- Zero orphan links when complete
- Every page links to 3-5+ related pages

### Files
- Filename = page title with spaces and capitalization
- Extension: `.md`
- Location: repository root (flat structure)
- Scripts: `_bin/` directory

### Depth Classification
Every conversation thread page is marked with one of:
- **Deep thread** — multiple minutes of substantive three-way exchange
- **Medium thread** — a few minutes, some substance
- **Brief mention** — a sentence or two, stub page

### Attribution
Even with three speakers, every page tracks who introduced topics, who has direct experience, and who is responding.

## Source Materials

The original call artifacts are in the repository root:
- `jessie, pete, nameless one, 2026-02-20 - meeting_saved_closed_caption.txt` — the full Zoom transcript
- `meeting_saved_new_chat.txt` — the Zoom chat with links and real-time research

## Tools

- **[[Claude Code]]** — built the wiki from the transcript
- **`_bin/find-orphan-links.py`** — finds wiki links without corresponding .md files
- **`_bin/fix-linebreaks.py`** — utility for transcript formatting

## Related

- [[README]] — start here
- [[Wiki Creation Process]] — methodology
- [[Work Log]] — process journal
